'-------------------------------------------------
'-- Structural breaks in GDP series
'-- July 09
'-------------------------------------------------


'-------------------------------------------------
'-- I. Loading the file
'-------------------------------------------------


%the_path = "L:\MED\SDP\DRA\Projects\2009_Upper_Tsatsaronis\Prog\Eviews\FINAL_OUTPUT"
cd %the_path

wfcreate(wf=exercise_end_official, page = raw_data) q 1960Q1 2009Q1
read(S=Data) GDP.XLS 37


spool Graphs

'-------------------------------------------------
'-- II. Deriving variables
'-------------------------------------------------

for %y  AR BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE

	series level{%y}     = log(rgdp{%y})
	series D{%y}=0
	series dummy{%y}=0
	series I_{%y}=0	

next



'Dummy variables

'Special case AR, BR & CO: more than 1 structural break

for !p=1 to 4
	
	series DAR{!p} = 0
	series dummyAR{!p}=0
	series I_AR{!p}=0


next

for %x br 
	for !p=1 to 2
		series D{%x}{!p}=0
		series dummy{%x}{!p}=0	
		series I_{%x}{!p}=0
	next
next

smpl 1985Q1 1987Q1
dummyar1.fill(s1,l) 1		 'Special case: 1980Q1 is also the beginning of the smpl: to allow for some initial observations we set it at 1985Q1
smpl 1989Q4 1992Q1
dummyar2.fill(s,l) 1
smpl 1995Q1 1996Q4
dummyar3.fill(s,l) 1
smpl 2001Q4  2005Q2
dummyar4.fill(s,l) 1

smpl 1987Q1 @last
I_ar1.fill(s,l) 1 		'Special case: 1980Q1 is also the beginning of the smpl: to allow for some initial observations we set it at 1985Q1
smpl 1992Q1 @last
I_ar2.fill(s,l) 1
smpl 1996Q4 @last
I_ar3.fill(s,l) 1
smpl 2005Q2 @last
I_ar4.fill(s,l) 1


smpl 1990Q1 1991Q3
dummybr1.fill(s,l) 1
smpl 1994Q4 1996Q3
dummybr2.fill(s,l) 1
smpl 1991Q3 @last 
I_br1.fill(s,l) 1
smpl 1996Q3 @last
I_br2.fill(s,l) 1


smpl 1996Q1 2002Q4
dummybg.fill(s,l) 1
smpl 2002Q4 @last
I_bg.fill(s,l) 1


'dummycl.fill(o=1981Q4,l) 1
smpl 1985Q1 1987Q1
dummycl.fill(s,l) 1
smpl 1987Q1 @last
I_cl.fill(s,l) 1

smpl 1998Q2 2001Q4
dummyco.fill(s,l) 1
smpl 2001Q4 @last
I_co.fill(s,l) 1

smpl 1988Q1 1989Q2
dummyci.fill(s,l) 1
smpl 1989Q2 @last
I_ci.fill(s,l) 1

smpl 1998Q1 1999Q3
dummyhr.fill(s,l) 1
smpl 1999Q3 @last
I_hr.fill(s,l) 1


smpl 1996Q1 1999Q2
dummycz.fill(s,l) 1
smpl 1999Q2 @last
I_cz.fill(s,l) 1


smpl 2003Q2 2005Q2
dummydm.fill(s,l) 1
smpl 2005Q2 @last
I_dm.fill(s,l) 1


smpl 1998Q3 2001Q2
dummyec.fill(s,l) 1
smpl 2001Q2 @last
I_ec.fill(s,l) 1


smpl 1992Q4 2001Q1
dummyee.fill(s,l) 1
smpl 2001Q1 @last
I_ee.fill(s,l) 1


smpl 1991Q3 1997Q4
dummyfi.fill(s,l) 1
smpl 1997Q4 @last
I_fi.fill(s,l) 1



'dummygh.fill(o=1982Q1,l) 1
smpl 1986Q1 1987Q1
dummygh.fill(s,l) 1
smpl 1987Q1 @last
I_gh.fill(s,l) 1


smpl 1997Q4 2003Q1
dummyid.fill(s,l) 1
smpl 2003Q1 @last
I_id.fill(s,l) 1


smpl 1996Q4 2001Q3
dummyjm.fill(s,l) 1
smpl 2001Q3 @last
I_jm.fill(s,l) 1


smpl 1997Q4  2001Q3
dummyjp.fill(s,l) 1
smpl  2001Q3 @last
I_jp.fill(s,l) 1


smpl 1997Q3 1999Q2
dummykr.fill(s,l) 1
smpl 1999Q2 @last
I_kr.fill(s,l) 1


smpl 1995Q2 1997Q1
dummylv.fill(s,l) 1
smpl  1997Q1 @last
I_lv.fill(s,l) 1


smpl 1995Q4 1996Q2
dummylt.fill(s,l) 1
smpl 1996Q2 @last
I_lt.fill(s,l) 1


smpl 1997Q3 1999Q4
dummymy.fill(s,l) 1
smpl 1999Q4 @last
I_my.fill(s,l) 1


smpl 1994Q4 1997Q1
dummymx.fill(s,l) 1
smpl 1997Q1 @last
I_mx.fill(s,l) 1


smpl 1991Q3 1992Q3
dummyno.fill(s,l) 1
smpl 1992Q3 @last
I_no.fill(s,l) 1

smpl 1997Q3 1999Q1
dummyph.fill(s,l) 1
smpl 1999Q1 @last
I_ph.fill(s,l) 1


smpl 1998Q3 2000Q3
dummyru.fill(s,l) 1
smpl 2000Q3 @last
I_ru.fill(s,l) 1


smpl 1991Q3 1995Q3
dummyse.fill(s,l) 1
smpl 1995Q3 @last
I_se.fill(s,l) 1


smpl 1997Q3 2003Q2
dummyth.fill(s,l) 1
smpl 2003Q2 @last
I_th.fill(s,l) 1



smpl 2000Q4 2002Q4
dummytr.fill(s,l) 1
smpl 2002Q4 @last
I_tr.fill(s,l) 1



smpl 1998Q1 2001Q4
dummyua.fill(s,l) 1
smpl 2001Q4 @last
I_ua.fill(s,l) 1



smpl 2002Q1 2006Q3
dummyuy.fill(s,l) 1
smpl 2006Q3 @last
I_uy.fill(s,l) 1



smpl 1994Q1 1996Q1
dummyve.fill(s,l) 1
smpl  1996Q1 @last
I_ve.fill(s,l) 1



smpl @all



Dar1.fill(o=1985Q1,l) 1 'Special case: 1980Q1 is also the beginning of the smpl: to allow for some initial observations we set it at 1985Q1
Dar2.fill(o=1989Q4,l) 1
Dar3.fill(o=1995Q1,l) 1
Dar4.fill(o=2001Q4,l) 1

Dbr1.fill(o=1990Q1,l) 1
Dbr2.fill(o=1994Q4,l) 1

Dbg.fill(o=1996Q1,l) 1

'Dcl.fill(o=1981Q4,l) 1
Dcl.fill(o=1985Q1,l) 1

Dco.fill(o=1998Q2,l) 1

Dci.fill(o=1988Q1,l) 1

Dhr.fill(o=1998Q1,l) 1

Dcz.fill(o=1996Q1,l) 1

Ddm.fill(o=2003Q2,l) 1

Dec.fill(o=1998Q3,l) 1

Dee.fill(o=1992Q4,l) 1

Dfi.fill(o=1991Q3,l) 1

'Dgh.fill(o=1982Q1,l) 1
Dgh.fill(o=1986Q1,l) 1

Did.fill(o=1997Q4,l) 1

Djm.fill(o=1996Q4,l) 1

Djp.fill(o=1997Q4,l) 1

Dkr.fill(o=1997Q3,l) 1

Dlv.fill(o=1995Q2,l) 1

Dlt.fill(o=1995Q4,l) 1

Dmy.fill(o=1997Q3,l) 1

Dmx.fill(o=1994Q4,l) 1

Dno.fill(o=1991Q3,l) 1

Dph.fill(o=1997Q3,l) 1

Dru.fill(o=1998Q3,l) 1

Dse.fill(o=1991Q3,l) 1

Dth.fill(o=1997Q3,l) 1

Dtr.fill(o=2000Q4,l) 1

Dua.fill(o=1998Q1,l) 1

Duy.fill(o=2002Q1,l) 1

Dve.fill(o=1994Q1,l) 1



' Copy the series with the exact range

for %y ar br cl co id  jp mx

	if %y = "ar" then 

		pagecreate(page={%y}) q 1980q1 2009q1 
		copy(smpl="1980q1 2009q1") raw_data\level{%y}  {%y}\level{%y} 
		for !i=1 to 4 
			copy(smpl="1980q1 2009q1") raw_data\dummy{%y}{!i} {%y}\dummy{%y}{!i}  
			copy(smpl="1980q1 2009q1") raw_data\I_{%y}{!i} {%y}\I_{%y}{!i}    
			copy(smpl="1980q1 2009q1") raw_data\D{%y}{!i} {%y}\D{%y}{!i} 
		next 

	else

		if %y = "br" then 

			pagecreate(page={%y}) q 1980q1 2009q1 level{%y}
			copy(smpl="1980q1 2009q1") raw_data\level{%y}  {%y}\level{%y}
			for !i=1 to 2 
				copy(smpl="1980q1 2009q1") raw_data\dummy{%y}{!i} {%y}\dummy{%y}{!i}
				copy(smpl="1980q1 2009q1") raw_data\I_{%y}{!i} {%y}\I_{%y}{!i}    
				copy(smpl="1980q1 2009q1") raw_data\D{%y}{!i} {%y}\D{%y}{!i}    
			next		
		else

			pagecreate(page={%y}) q 1980q1 2009q1 level{%y}
			copy(smpl="1980q1 2009q1") raw_data\level{%y}  {%y}\level{%y}
			copy(smpl="1980q1 2009q1") raw_data\dummy{%y} {%y}\dummy{%y}
			copy(smpl="1980q1 2009q1") raw_data\I_{%y} {%y}\I_{%y}
			copy(smpl="1980q1 2009q1") raw_data\D{%y} {%y}\D{%y}

		endif
		
	endif

next


for %y bg ci  hr  ec gh jm ru ua uy 
	pagecreate(page={%y}) q 1980q4 2008q4 level{%y}
	copy(smpl="1980q4 2008q4") raw_data\level{%y} {%y}\level{%y}
	copy(smpl="1980q4 2008q4") raw_data\dummy{%y}  {%y}\dummy{%y}
	copy(smpl="1980q4 2008q4") raw_data\I_{%y}  {%y}\I_{%y}
	copy(smpl="1980q4 2008q4") raw_data\D{%y}  {%y}\D{%y}
next


for %y cz ee lt ve
	pagecreate(page={%y}) q 1980q4 2008q4 level{%y}
	copy(smpl="1980q4 2009q1") raw_data\dummy{%y}  {%y}\dummy{%y}
	copy(smpl="1980q4 2009q1") raw_data\level{%y}  {%y}\level{%y} 
	copy(smpl="1980q4 2009q1") raw_data\I_{%y}  {%y}\I_{%y} 
	copy(smpl="1980q4 2009q1") raw_data\D{%y}  {%y}\D{%y} 
next

pagecreate(page=dm) q 1992q1 2008q4 leveldm
copy(smpl="1992q1 2008q4") raw_data\leveldm  dm\leveldm 
copy(smpl="1992q1 2008q4") raw_data\dummydm dm\dummydm
copy(smpl="1992q1 2008q4") raw_data\I_dm dm\I_dm
copy(smpl="1992q1 2008q4") raw_data\Ddm dm\Ddm

pagecreate(page=fi) q 1975q1 2009q1 levelfi
copy(smpl="1975q1 2009q1") raw_data\levelfi  fi\levelfi 
copy(smpl="1975q1 2009q1") raw_data\dummyfi fi\dummyfi
copy(smpl="1975q1 2009q1") raw_data\I_fi fi\I_fi
copy(smpl="1975q1 2009q1") raw_data\Dfi fi\Dfi

pagecreate(page=kr) q 1960q1 2009q1 levelkr
copy(smpl="1960q1 2009q1") raw_data\levelkr kr\levelkr
copy(smpl="1960q1 2009q1") raw_data\dummykr kr\dummykr
copy(smpl="1960q1 2009q1") raw_data\I_kr kr\I_kr
copy(smpl="1960q1 2009q1") raw_data\Dkr kr\Dkr

pagecreate(page=ph) q 1973q1 2009q1 levelph
copy(smpl="1973q1 2009q1") raw_data\levelph ph\levelph 
copy(smpl="1973q1 2009q1") raw_data\dummyph ph\dummyph
copy(smpl="1973q1 2009q1") raw_data\I_ph ph\I_ph
copy(smpl="1973q1 2009q1") raw_data\Dph ph\Dph

pagecreate(page=se) q 1984q1 2009q1 levelse
copy(smpl="1984q1 2009q1") raw_data\levelse se\levelse 
copy(smpl="1984q1 2009q1") raw_data\dummyse se\dummyse
copy(smpl="1984q1 2009q1") raw_data\I_se se\I_se
copy(smpl="1984q1 2009q1") raw_data\Dse se\Dse

pagecreate(page=th) q 1993q1 2009q1 levelth
copy(smpl="1993q1 2009q1") raw_data\levelth th\levelth 
copy(smpl="1993q1 2009q1") raw_data\dummyth th\dummyth
copy(smpl="1993q1 2009q1") raw_data\I_th th\I_th
copy(smpl="1993q1 2009q1") raw_data\Dth th\Dth

pagecreate(page=tr) q 1987q1 2009q1 leveltr
copy(smpl="1987q1 2009q1") raw_data\leveltr tr\leveltr
copy(smpl="1987q1 2009q1") raw_data\dummytr tr\dummytr
copy(smpl="1987q1 2009q1") raw_data\I_tr tr\I_tr
copy(smpl="1987q1 2009q1") raw_data\Dtr tr\Dtr

pagecreate(page=lv) q 1990q1 2008q4 levellv
copy(smpl="1990q1 2008q4") raw_data\levellv lv\levellv
copy(smpl="1990q1 2008q4") raw_data\dummylv lv\dummylv
copy(smpl="1990q1 2008q4") raw_data\I_lv lv\I_lv
copy(smpl="1990q1 2008q4") raw_data\Dlv lv\Dlv

pagecreate(page=my) q 1988q1 2009q1 levelmy
copy(smpl="1988q1 2009q1") raw_data\levelmy my\levelmy
copy(smpl="1988q1 2009q1") raw_data\dummymy my\dummymy
copy(smpl="1988q1 2009q1") raw_data\I_my my\I_my
copy(smpl="1988q1 2009q1") raw_data\Dmy my\Dmy

pagecreate(page=no) q 1985q1 2009q1 levelno
copy(smpl="1985q1 2009q1") raw_data\levelno no\levelno
copy(smpl="1985q1 2009q1") raw_data\dummyno no\dummyno
copy(smpl="1985q1 2009q1") raw_data\I_no no\I_no
copy(smpl="1985q1 2009q1") raw_data\Dno no\Dno


'The equations will be moved to this dedicated page (we will produce here the table with the coefficients for all countries)

pagecreate(page=model_log) q 1960q1 2009q1
pagecreate(page=model_1dummy) q 1960q1 2009q1
pagecreate(page=model_2dummies) q 1960q1 2009q1
pagecreate(page=u_roots) q 1960q1 2009q1
pagecreate(page=chow) q 1960q1 2009q1
pagecreate(page=quandt) q 1960q1 2009q1


'---------------------------------------------------------------------------------------------
'-- III. Computing the model on log y = a + bt + error and fitted values
'---------------------------------------------------------------------------------------------


for %y AR BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE
	
	pageselect {%y}

	equation eq_{%y}.ls(n)	level{%y}  c @trend
	copy {%y}\eq_{%y} model_log\eq_{%y}


	'Unit root
	eq_{%y}.makeresids res_{%y}
	freeze(res_{%y}_none) 	res_{%y}.uroot(none)
	copy {%y}\res_{%y}_none u_roots\res_{%y}_none

	'Fitting values
	eq_{%y}.fit {%y}_fitted {%y}_fitted_se
		
	'Break test UNknown: Andrews-Quandt test
	freeze(quandt_{%y}) 		eq_{%y}.ubreak 15  
	freeze(quandt_{%y}_c) 	eq_{%y}.ubreak 15  @ c
	freeze(quandt_{%y}_trend) 	eq_{%y}.ubreak 15  @ @trend
	copy {%y}\quandt_{%y} quandt\quandt_{%y}
	copy {%y}\quandt_{%y}_c quandt\quandt_{%y}_c
	copy {%y}\quandt_{%y}_trend quandt\quandt_{%y}_trend

next 


'--------------------------------------------------------------
'-- IV. Break in series
'--------------------------------------------------------------

' IV.I: Break test known: Chow
'-----------------------------------------


pageselect ar
freeze(chow_ar1) eq_ar.chow 1985Q1
freeze(chow_ar2) eq_ar.chow 1989Q4
freeze(chow_ar3) eq_ar.chow 1995Q1
freeze(chow_ar4) eq_ar.chow 2001Q4

freeze(chow_ar1_C) eq_ar.chow 1985Q1 @ c
freeze(chow_ar2_C) eq_ar.chow 1989Q4 @ c
freeze(chow_ar3_C) eq_ar.chow 1995Q1 @ c
freeze(chow_ar4_C) eq_ar.chow 2001Q4 @ c

freeze(chow_ar1_trend) eq_ar.chow 1985Q1 @ @trend
freeze(chow_ar2_trend) eq_ar.chow 1989Q4 @ @trend
freeze(chow_ar3_trend) eq_ar.chow 1995Q1 @ @trend
freeze(chow_ar4_trend) eq_ar.chow 2001Q4 @ @trend


pageselect br
freeze(chow_br1) eq_br.chow 1990Q1
freeze(chow_br2) eq_br.chow 1994Q4
freeze(chow_br1_C) eq_br.chow 1990Q1 @ c
freeze(chow_br2_C) eq_br.chow 1994Q4 @ c
freeze(chow_br1_trend) eq_br.chow 1990Q1 @ @trend
freeze(chow_br2_trend) eq_br.chow 1994Q4 @ @trend

pageselect bg
freeze(chow_bg) eq_bg.chow 1996Q1
freeze(chow_bg_C) eq_bg.chow 1996Q1 @ c
freeze(chow_bg_trend) eq_bg.chow 1996Q1 @ @trend

pageselect cl
freeze(chow_cl) eq_cl.chow 1985Q1
'freeze(chow_cl) eq_cl.chow 1981Q4
freeze(chow_cl_C) eq_cl.chow 1985Q1 @ c
'freeze(chow_cl) eq_cl.chow 1981Q4
freeze(chow_cl_trend) eq_cl.chow 1985Q1 @ @trend
'freeze(chow_cl) eq_cl.chow 1981Q4

pageselect co
freeze(chow_co) eq_co.chow 1998Q2
freeze(chow_co_C) eq_co.chow 1998Q2 @ c
freeze(chow_co_trend) eq_co.chow 1985Q4 @ @trend


pageselect ci
freeze(chow_ci) eq_ci.chow 1988Q1
freeze(chow_ci_C) eq_ci.chow 1988Q1 @ c
freeze(chow_ci_trend) eq_ci.chow 1988Q1 @ @trend

pageselect hr
freeze(chow_hr) eq_hr.chow 1998Q1
freeze(chow_hr_C) eq_hr.chow 1998Q1 @ c
freeze(chow_hr_trend) eq_hr.chow 1998Q1 @ @trend

pageselect cz
freeze(chow_cz) eq_cz.chow 1996Q1
freeze(chow_cz_C) eq_cz.chow 1996Q1 @ c
freeze(chow_cz_trend) eq_cz.chow 1996Q1 @ @trend

pageselect dm
freeze(chow_dm) eq_dm.chow 2003Q2
freeze(chow_dm_C) eq_dm.chow 2003Q2 @ c
freeze(chow_dm_trend) eq_dm.chow 2003Q2 @ @trend

pageselect ec
freeze(chow_ec) eq_ec.chow 1998Q3
freeze(chow_ec_C) eq_ec.chow 1998Q3 @ c
freeze(chow_ec_trend) eq_ec.chow 1998Q3 @ @trend

pageselect ee
freeze(chow_ee) eq_ee.chow 1992Q4
freeze(chow_ee_C) eq_ee.chow 1992Q4 @ c
freeze(chow_ee_trend) eq_ee.chow 1992Q4 @ @trend

pageselect fi
freeze(chow_fi) eq_fi.chow 1991Q3
freeze(chow_fi_C) eq_fi.chow 1991Q3 @ c
freeze(chow_fi_trend) eq_fi.chow 1991Q3 @ @trend

pageselect gh
'freeze(chow_gh) eq_gh.chow 1982Q1
freeze(chow_gh) eq_gh.chow 1986Q1
'freeze(chow_gh) eq_gh.chow 1982Q1
freeze(chow_gh_C) eq_gh.chow 1986Q1 @ c
'freeze(chow_gh) eq_gh.chow 1982Q1
freeze(chow_gh_trend) eq_gh.chow 1986Q1 @ @trend

pageselect id
freeze(chow_id) eq_id.chow 1997Q4
freeze(chow_id_C) eq_id.chow 1997Q4 @ c
freeze(chow_id_trend) eq_id.chow 1997Q4 @ @trend

pageselect jm
freeze(chow_jm) eq_jm.chow 1996Q4
freeze(chow_jm_C) eq_jm.chow 1996Q4 @ c
freeze(chow_jm_trend) eq_jm.chow 1996Q4 @ @trend

pageselect jp
freeze(chow_jp) eq_jp.chow 1997Q4
freeze(chow_jp_C) eq_jp.chow 1997Q4 @ c
freeze(chow_jp_trend) eq_jp.chow 1997Q4 @ @trend

pageselect kr
freeze(chow_kr) eq_kr.chow 1997Q3
freeze(chow_kr_C) eq_kr.chow 1997Q3 @ c
freeze(chow_kr_trend) eq_kr.chow 1997Q3 @ @trend

pageselect lv
freeze(chow_lv) eq_lv.chow 1995Q2
freeze(chow_lv_C) eq_lv.chow 1995Q2 @ c
freeze(chow_lv_trend) eq_lv.chow 1995Q2 @ @trend

pageselect lt
freeze(chow_lt) eq_lt.chow 1995Q4
freeze(chow_lt_C) eq_lt.chow 1995Q4 @ c
freeze(chow_lt_trend) eq_lt.chow 1995Q4 @ @trend

pageselect my
freeze(chow_my) eq_my.chow 1997Q3
freeze(chow_my_C) eq_my.chow 1997Q3 @ c
freeze(chow_my_trend) eq_my.chow 1997Q3 @ @trend

pageselect mx
freeze(chow_mx) eq_mx.chow 1994Q4
freeze(chow_mx_C) eq_mx.chow 1994Q4 @ c
freeze(chow_mx_trend) eq_mx.chow 1994Q4 @ @trend

pageselect no
freeze(chow_no) eq_no.chow 1991Q3
freeze(chow_no_C) eq_no.chow 1991Q3 @ c
freeze(chow_no_trend) eq_no.chow 1991Q3 @ @trend

pageselect ph
freeze(chow_ph) eq_ph.chow 1997Q3
freeze(chow_ph_C) eq_ph.chow 1997Q3 @ c
freeze(chow_ph_trend) eq_ph.chow 1997Q3 @ @trend

pageselect ru
freeze(chow_ru) eq_ru.chow 1998Q3
freeze(chow_ru_C) eq_ru.chow 1998Q3 @ c
freeze(chow_ru_trend) eq_ru.chow 1998Q3 @ @trend

pageselect se
freeze(chow_se) eq_se.chow 1991Q3
freeze(chow_se_C) eq_se.chow 1991Q3 @ c
freeze(chow_se_trend) eq_se.chow 1991Q3 @ @trend

pageselect th
freeze(chow_th) eq_th.chow 1997Q3
freeze(chow_th_C) eq_th.chow 1997Q3 @ c
freeze(chow_th_trend) eq_th.chow 1997Q3 @ @trend

pageselect tr
freeze(chow_tr) eq_tr.chow 2000Q4
freeze(chow_tr_C) eq_tr.chow 2000Q4 @ c
freeze(chow_tr_trend) eq_tr.chow 2000Q4 @ @trend

pageselect ua
freeze(chow_ua) eq_ua.chow 1998Q1
freeze(chow_ua_C) eq_ua.chow 1998Q1 @ c
freeze(chow_ua_trend) eq_ua.chow 1998Q1 @ @trend

pageselect uy
freeze(chow_uy) eq_uy.chow 2002Q1
freeze(chow_uy_C) eq_uy.chow 2002Q1 @ c
freeze(chow_uy_trend) eq_uy.chow 2002Q1 @ @trend

pageselect ve
freeze(chow_ve) eq_ve.chow 1994Q1
freeze(chow_ve_C) eq_ve.chow 1994Q1 @ c
freeze(chow_ve_trend) eq_ve.chow 1994Q1 @ @trend


for %y AR BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE

	if %y = "AR" then 
		
		for  !i=1 to 4		
			copy {%y}\chow_{%y}{!i}		chow\chow_{%y}{!i}
			copy {%y}\chow_{%y}{!i}_C 		chow\chow_{%y}{!i}_C 
			copy {%y}\chow_{%y}{!i}_trend 	chow\chow_{%y}{!i}_trend
		next

	else
		if  %y="BR" then
			for  !i=1 to 2	
				copy {%y}\chow_{%y}{!i} 		chow\chow_{%y}{!i}
				copy {%y}\chow_{%y}{!i}_C 		chow\chow_{%y}{!i}_C 
				copy {%y}\chow_{%y}{!i}_trend 	chow\chow_{%y}{!i}_trend	
			next
		else
			copy {%y}\chow_{%y} 		chow\chow_{%y}
			copy {%y}\chow_{%y}_C 		chow\chow_{%y}_C 
			copy {%y}\chow_{%y}_trend 		chow\chow_{%y}_trend		
		endif
	endif 

next




'------------------------------------------------------------------------------------------------------------
'-- V.Fitted values of log y = alpha + beta*t + error before the crisis 
'------------------------------------------------------------------------------------------------------------

pageselect ar 

smpl @first 1985Q1
equation eq_ar_1_pre_crisis.ls(n)	levelar  c @trend
smpl @all
eq_ar_1_pre_crisis.fit(f=na) fitted_ar_1_pre_crisis
copy ar\eq_ar_1_pre_crisis model_log\eq_ar_1_pre_crisis

smpl @first 1989Q4
equation eq_ar_2_pre_crisis.ls(n)	levelar  c @trend
smpl @all
eq_ar_2_pre_crisis.fit(f=na) fitted_ar_2_pre_crisis
copy ar\eq_ar_2_pre_crisis model_log\eq_ar_2_pre_crisis

smpl @first 1995Q1
equation eq_ar_3_pre_crisis.ls(n)	levelar  c @trend
smpl @all
eq_ar_3_pre_crisis.fit(f=na) fitted_ar_3_pre_crisis
copy ar\eq_ar_3_pre_crisis model_log\eq_ar_3_pre_crisis

smpl @first 2001Q4
equation eq_ar_4_pre_crisis.ls(n)	levelar  c @trend
smpl @all
eq_ar_4_pre_crisis.fit(f=na) fitted_ar_4_pre_crisis
copy ar\eq_ar_4_pre_crisis model_log\eq_ar_4_pre_crisis

pageselect br 

smpl @first 1990Q1
equation eq_br_1_pre_crisis.ls(n)	levelbr  c @trend
smpl @all
eq_br_1_pre_crisis.fit(f=na) fitted_br_1_pre_crisis
copy br\eq_br_1_pre_crisis model_log\eq_br_1_pre_crisis

smpl @first 1994Q4
equation eq_br_2_pre_crisis.ls(n)	levelbr  c @trend
smpl @all
eq_br_2_pre_crisis.fit(f=na) fitted_br_2_pre_crisis
copy br\eq_br_2_pre_crisis model_log\eq_br_2_pre_crisis


pageselect bg 
smpl @first 1996Q1
equation eq_bg_pre_crisis.ls(n)	levelbg  c @trend
smpl @all
eq_bg_pre_crisis.fit(f=na) fitted_bg_pre_crisis
copy bg\eq_bg_pre_crisis model_log\eq_bg_pre_crisis


pageselect cl 
smpl @first 1985Q1
equation eq_cl_pre_crisis.ls(n)	levelcl  c @trend
smpl @all
eq_cl_pre_crisis.fit(f=na) fitted_cl_pre_crisis
copy cl\eq_cl_pre_crisis model_log\eq_cl_pre_crisis


pageselect co 

smpl @first 1998Q2
equation eq_co_pre_crisis.ls(n)	levelco  c @trend
smpl @all
eq_co_pre_crisis.fit(f=na) fitted_co_pre_crisis
copy co\eq_co_pre_crisis model_log\eq_co_pre_crisis


pageselect ci 
smpl @first 1988Q1
equation eq_ci_pre_crisis.ls(n)	levelci  c @trend
smpl @all
eq_ci_pre_crisis.fit(f=na) fitted_ci_pre_crisis
copy ci\eq_ci_pre_crisis model_log\eq_ci_pre_crisis


pageselect hr 
smpl @first 1998Q1
equation eq_hr_pre_crisis.ls(n)	levelhr  c @trend
smpl @all
eq_hr_pre_crisis.fit(f=na) fitted_hr_pre_crisis
copy hr\eq_hr_pre_crisis model_log\eq_hr_pre_crisis


pageselect cz 
smpl @first 1996Q1
equation eq_cz_pre_crisis.ls(n)	levelcz  c @trend
smpl @all
eq_cz_pre_crisis.fit(f=na) fitted_cz_pre_crisis
copy cz\eq_cz_pre_crisis model_log\eq_cz_pre_crisis


pageselect dm 
smpl @first 2003Q2
equation eq_dm_pre_crisis.ls(n)	leveldm  c @trend
smpl @all
eq_dm_pre_crisis.fit(f=na) fitted_dm_pre_crisis
copy dm\eq_dm_pre_crisis model_log\eq_dm_pre_crisis


pageselect ec 
smpl @first 1998Q3
equation eq_ec_pre_crisis.ls(n)	levelec  c @trend
smpl @all
eq_ec_pre_crisis.fit(f=na) fitted_ec_pre_crisis
copy ec\eq_ec_pre_crisis model_log\eq_ec_pre_crisis

pageselect ee 
smpl @first 1992Q4
equation eq_ee_pre_crisis.ls(n)	levelee  c @trend
smpl @all
eq_ee_pre_crisis.fit(f=na) fitted_ee_pre_crisis
copy ee\eq_ee_pre_crisis model_log\eq_ee_pre_crisis


pageselect fi 
smpl @first 1991Q3
equation eq_fi_pre_crisis.ls(n)	levelfi  c @trend
smpl @all
eq_fi_pre_crisis.fit(f=na) fitted_fi_pre_crisis
copy fi\eq_fi_pre_crisis model_log\eq_fi_pre_crisis

pageselect gh 
smpl @first 1986Q1
equation eq_gh_pre_crisis.ls(n)	levelgh  c @trend
smpl @all
eq_gh_pre_crisis.fit(f=na) fitted_gh_pre_crisis
copy gh\eq_gh_pre_crisis model_log\eq_gh_pre_crisis

pageselect id 
smpl @first 1997Q4
equation eq_id_pre_crisis.ls(n)	levelid  c @trend
smpl @all
eq_id_pre_crisis.fit(f=na) fitted_id_pre_crisis
copy id\eq_id_pre_crisis model_log\eq_id_pre_crisis
pageselect jm 
smpl @first 1996Q4
equation eq_jm_pre_crisis.ls(n)	leveljm  c @trend
smpl @all
eq_jm_pre_crisis.fit(f=na) fitted_jm_pre_crisis
copy jm\eq_jm_pre_crisis model_log\eq_jm_pre_crisis

pageselect jp 
smpl @first 1997Q4
equation eq_jp_pre_crisis.ls(n)	leveljp  c @trend
smpl @all
eq_jp_pre_crisis.fit(f=na) fitted_jp_pre_crisis
copy jp\eq_jp_pre_crisis model_log\eq_jp_pre_crisis

pageselect kr 
smpl @first 1997Q3
equation eq_kr_pre_crisis.ls(n)	levelkr  c @trend
smpl @all
eq_kr_pre_crisis.fit(f=na) fitted_kr_pre_crisis
copy kr\eq_kr_pre_crisis model_log\eq_kr_pre_crisis

pageselect lv 
smpl @first 1995Q2
equation eq_lv_pre_crisis.ls(n)	levellv  c @trend
smpl @all
eq_lv_pre_crisis.fit(f=na) fitted_lv_pre_crisis
copy lv\eq_lv_pre_crisis model_log\eq_lv_pre_crisis

pageselect lt 
smpl @first 1995Q4
equation eq_lt_pre_crisis.ls(n)	levellt  c @trend
smpl @all
eq_lt_pre_crisis.fit(f=na) fitted_lt_pre_crisis
copy lt\eq_lt_pre_crisis model_log\eq_lt_pre_crisis


pageselect my 
smpl @first 1997Q3
equation eq_my_pre_crisis.ls(n)	levelmy  c @trend
smpl @all
eq_my_pre_crisis.fit(f=na) fitted_my_pre_crisis
copy my\eq_my_pre_crisis model_log\eq_my_pre_crisis

pageselect mx 
smpl @first 1994Q4
equation eq_mx_pre_crisis.ls(n)	levelmx  c @trend
smpl @all
eq_mx_pre_crisis.fit(f=na) fitted_mx_pre_crisis
copy mx\eq_mx_pre_crisis model_log\eq_mx_pre_crisis

pageselect no 
smpl @first 1991Q3
equation eq_no_pre_crisis.ls(n)	levelno  c @trend
smpl @all
eq_no_pre_crisis.fit(f=na) fitted_no_pre_crisis
copy no\eq_no_pre_crisis model_log\eq_no_pre_crisis


pageselect ph 
smpl @first 1997Q3
equation eq_ph_pre_crisis.ls(n)	levelph  c @trend
smpl @all
eq_ph_pre_crisis.fit(f=na) fitted_ph_pre_crisis
copy ph\eq_ph_pre_crisis model_log\eq_ph_pre_crisis


pageselect ru 
smpl @first 1998Q3
equation eq_ru_pre_crisis.ls(n)	levelru  c @trend
smpl @all
eq_ru_pre_crisis.fit(f=na) fitted_ru_pre_crisis
copy ru\eq_ru_pre_crisis model_log\eq_ru_pre_crisis


pageselect se 
smpl @first 1991Q3
equation eq_se_pre_crisis.ls(n)	levelse  c @trend
smpl @all
eq_se_pre_crisis.fit(f=na) fitted_se_pre_crisis
copy se\eq_se_pre_crisis model_log\eq_se_pre_crisis


pageselect th 
smpl @first 1997Q3
equation eq_th_pre_crisis.ls(n)	levelth  c @trend
smpl @all
eq_th_pre_crisis.fit(f=na) fitted_th_pre_crisis
copy th\eq_th_pre_crisis model_log\eq_th_pre_crisis

pageselect tr 
smpl @first 2000Q4
equation eq_tr_pre_crisis.ls(n)	leveltr  c @trend
smpl @all
eq_tr_pre_crisis.fit(f=na) fitted_tr_pre_crisis
copy tr\eq_tr_pre_crisis model_log\eq_tr_pre_crisis 

pageselect ua 
smpl @first 1998Q1
equation eq_ua_pre_crisis.ls(n)	levelua  c @trend
smpl @all
eq_ua_pre_crisis.fit(f=na) fitted_ua_pre_crisis
copy ua\eq_ua_pre_crisis model_log\eq_ua_pre_crisis

pageselect uy 
smpl @first 2002Q1
equation eq_uy_pre_crisis.ls(n)	leveluy  c @trend
smpl @all
eq_uy_pre_crisis.fit(f=na) fitted_uy_pre_crisis
copy uy\eq_uy_pre_crisis model_log\eq_uy_pre_crisis

pageselect ve 
smpl @first 1994Q1
equation eq_ve_pre_crisis.ls(n)	levelve  c @trend
smpl @all
eq_ve_pre_crisis.fit(f=na) fitted_ve_pre_crisis
copy ve\eq_ve_pre_crisis model_log\eq_ve_pre_crisis




'------------------------------------------------------------------------------------------------------------
'-- V. Computing the model on log y = a + a1D + bt + b1Dt + error and fitted values
'------------------------------------------------------------------------------------------------------------



!i=1
for %y AR BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE
	
	pageselect {%y}
	spool Graphs_{%y}

	if %y = "AR" then 
		
		for !p=1 to 4 

			
			equation eq_dum_{!p}_ar.ls(n)		levelar c Dar{!p} @trend Dar{!p}*@trend
			equation eq_dum_{!p}_ar_c.ls(n)		levelar c Dar{!p} @trend	
			equation eq_dum_{!p}_ar_trend.ls(n)		levelar c @trend Dar{!p}*@trend			
			
			eq_dum_{!p}_ar.fit D{!p}_ar_fitted D{!p}_ar_fitted_se
			
			copy {%y}\eq_dum_{!p}_ar 		model_1dummy\eq_dum_{!p}_ar
			copy {%y}\eq_dum_{!p}_ar_c 	model_1dummy\eq_dum_{!p}_ar_c
			copy {%y}\eq_dum_{!p}_ar_trend 	model_1dummy\eq_dum_{!p}_ar_trend

			group fig_{%y}_{!p}  fitted_{%y}_{!p}_pre_crisis D{!p}_{%y}_fitted level{%y}
			freeze(g_{%y}_{!p}) fig_{%y}_{!p}.line
			Graphs_{%y}.append g_{%y}_{!p}
			
			series diff_{%y}_{!p} = @abs( fitted_{%y}_{!p}_pre_crisis -  D{!p}_{%y}_fitted)
			diff_{%y}_{!p}.sort
			close diff_{%y}_{!p}

			smpl if Dar{!p}=0	
			scalar nbobs_{!p}_{%y}  = @obssmpl
			smpl @all
			copy {%y}\nbobs_{!p}_{%y} 	model_1dummy\nbobs_{!p}_{%y}

		next 

	else

		if  %y="BR"  then

			for !p=1 to 2

				equation eq_dum_{!p}_{%y}.ls(n)		level{%y} c D{%y}{!p} @trend D{%y}{!p}*@trend	
				equation eq_dum_{!p}_{%y}_c.ls(n)		level{%y} c D{%y}{!p} @trend 
				equation eq_dum_{!p}_{%y}_trend.ls(n)	level{%y} c @trend D{%y}{!p}*@trend
				
				eq_dum_{!p}_{%y}.fit D{!p}_{%y}_fitted D{!p}_{%y}_fitted_se
				
				copy {%y}\eq_dum_{!p}_{%y} 	model_1dummy\eq_dum_{!p}_{%y}
				copy {%y}\eq_dum_{!p}_{%y}_c 	model_1dummy\eq_dum_{!p}_{%y}_c
				copy {%y}\eq_dum_{!p}_{%y}_trend  model_1dummy\eq_dum_{!p}_{%y}_trend

				group fig_{%y}_{!p}  fitted_{%y}_{!p}_pre_crisis D{!p}_{%y}_fitted  level{%y}
				freeze(g_{%y}_{!p}) fig_{%y}_{!p}.line
				Graphs_{%y}.append g_{%y}_{!p}
				
				series diff_{%y}_{!p} = @abs( fitted_{%y}_{!p}_pre_crisis -  D{!p}_{%y}_fitted)
				diff_{%y}_{!p}.sort
				close diff_{%y}_{!p}
	
				smpl if D{%y}{!p}=0	
				scalar nbobs_{!p}_{%y}  = @obssmpl
				smpl @all				
				copy {%y}\nbobs_{!p}_{%y} 	model_1dummy\nbobs_{!p}_{%y}

			next 

		else 

			equation eq_dum_{%y}.ls(n)		level{%y} c D{%y} @trend D{%y}*@trend
			equation eq_dum_{%y}_c.ls(n)	level{%y} c D{%y} @trend 
			equation eq_dum_{%y}_trend.ls(n)	level{%y} c @trend D{%y}*@trend
	
			eq_dum_{%y}.fit D_{%y}_fitted D_{%y}_fitted_se	
			
			copy {%y}\eq_dum_{%y} 		model_1dummy\eq_dum_{%y}
			copy {%y}\eq_dum_{%y}_c 		model_1dummy\eq_dum_{%y}_c
			copy {%y}\eq_dum_{%y}_trend 	model_1dummy\eq_dum_{%y}_trend
	
			group fig_{%y} fitted_{%y}_pre_crisis D_{%y}_fitted level{%y}
			freeze(g_{%y}) fig_{%y}.line
			Graphs_{%y}.append g_{%y}
			
			series diff_{%y} = @abs( fitted_{%y}_pre_crisis -  D_{%y}_fitted)
			diff_{%y}.sort
			close diff_{%y}

			smpl if D{%y}=0	
			scalar nbobs_{%y}  = @obssmpl
			smpl @all				
			copy {%y}\nbobs_{%y} 	model_1dummy\nbobs_{%y}


		endif

	endif	


copy {%y}\Graphs_{%y} raw_data\Graphs_{%y}
pageselect raw_data
Graphs.append Graphs_{%y}
delete Graphs_{%y}


!i=!i+1
next



'------------------------------------------------------------------------------------------------------------
'-- VI. Computing the model on log y = a + a1D + a2I + bt + b1Dt + b2Dt + error
'------------------------------------------------------------------------------------------------------------

!i=1
for %y AR BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE

	pageselect {%y}


	if %y = "AR" then 

		for !p=1 to 4 

			equation eq_2dum_{!p}_ar_all.ls(n)		levelar c dummyar{!p} I_ar{!p} @trend dummyar{!p}*@trend I_ar{!p}*@trend	
			equation eq_2dum_{!p}_ar_c.ls(n)		levelar c dummyar{!p} I_ar{!p} @trend 
			equation eq_2dum_{!p}_ar_trend.ls(n)	levelar c @trend dummyar{!p}*@trend I_ar{!p}*@trend
			
			copy {%y}\eq_2dum_{!p}_ar_all 		model_2dummies\eq_2dum_{!p}_ar_all
			copy {%y}\eq_2dum_{!p}_ar_c 		model_2dummies\eq_2dum_{!p}_ar_c
			copy {%y}\eq_2dum_{!p}_ar_trend 		model_2dummies\eq_2dum_{!p}_ar_trend
	
		next 

	else

		if  %y="BR"  then

			for !p=1 to 2

				equation eq_2dum_{!p}_{%y}_all.ls(n)	level{%y} c dummy{%y}{!p} I_{%y}{!p} @trend dummy{%y}{!p}*@trend I_{%y}{!p}*@trend
				equation eq_2dum_{!p}_{%y}_c.ls(n)		level{%y} c dummy{%y}{!p} I_{%y}{!p} @trend 
				equation eq_2dum_{!p}_{%y}_trend.ls(n)	level{%y} c @trend dummy{%y}{!p}*@trend I_{%y}{!p}*@trend

				copy {%y}\eq_2dum_{!p}_{%y}_all		model_2dummies\eq_2dum_{!p}_{%y}_all
				copy {%y}\eq_2dum_{!p}_{%y}_c 		model_2dummies\eq_2dum_{!p}_{%y}_c
				copy {%y}\eq_2dum_{!p}_{%y}_trend  	model_2dummies\eq_2dum_{!p}_{%y}_trend

			next 

		else 

			equation eq_2dum_{%y}_all.ls(n)	level{%y} c dummy{%y} I_{%y} @trend dummy{%y}*@trend I_{%y}*@trend			
			equation eq_2dum_{%y}_c.ls(n)	level{%y} c dummy{%y} I_{%y} @trend
			equation eq_2dum_{%y}_trend.ls(n)	level{%y} c @trend dummy{%y}*@trend I_{%y}*@trend

			copy {%y}\eq_2dum_{%y}_all		model_2dummies\eq_2dum_{%y}_all
			copy {%y}\eq_2dum_{%y}_c 		model_2dummies\eq_2dum_{%y}_c
			copy {%y}\eq_2dum_{%y}_trend 	model_2dummies\eq_2dum_{%y}_trend
	
		endif

	endif	
	
next 



'------------------------------------------------
'TABULATE INFO
'------------------------------------------------


'I. Unit roots
'------------------------------------------------


pageselect  u_roots

table(30,33) uroot_output

setcell (uroot_output,1,1,"Unit roots","l")

uroot_output.settextcolor(1,1) blue
uroot_output.setfont(1,1) +b 14pt
uroot_output.setfont(2,1) -b 10pt

setline(uroot_output,4)

setcell (uroot_output,2,1,"Augmented Dickey-Fuller test statistic - residuals base equation","l")

uroot_output(3,1)="Null hypothesis: the series has a unit root"
uroot_output(5,1)="P-value"

uroot_output(6,2)="Neither trend nor constant"


!i = 7
for %x AR BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE


	uroot_output(!i,1)=%x
	
	uroot_output(!i,2)= res_{%x}_none(7,5) 
	

	!i = !i+1

next



'II.Chow breakpoint test
'------------------------------------------------

pageselect chow

table(41,8) chow

setcell (chow,1,1,"Chow breakpoint test","l")
chow.settextcolor(1,1) blue
chow.setfont(1,1) +b 14pt
chow.setfont(2,1) -b 10pt

setcell (chow,2,1,"Both level & trend","l")
chow(3,1)="log(real gdp) = alpha + beta*t + error"
chow(4,1)="Null hypothesis: no breaks at specified breakpoints"
setline(chow,5)

chow(6,2)="Beginning crisis"
chow(7,3)="Prob F"
chow(7,4)="Prob Chi-Square"


!i = 8
for %x AR1 AR2 AR3 AR4 BR1 BR2 BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE

	chow(!i,1)= %x
	chow(!i,2)= @right(chow_{%x}(1,1),7)
	chow(!i,3)= chow_{%x}(6,5)
	chow(!i,4)= chow_{%x}(7,5)
		
	!i = !i+1

next



table(41,8) chow_c

setcell (chow_c,1,1,"Chow breakpoint test","l")

chow_c.settextcolor(1,1) blue
chow_c.setfont(1,1) +b 14pt
chow_c.setfont(2,1) -b 10pt

setcell (chow_c,2,1,"Level","l")
chow_c(3,1)="log(real gdp) = alpha + beta*t + error"
chow_c(4,1)="Null hypothesis: no breaks at specified breakpoints"
setline(chow,5)


chow_c(6,2)="Beginning crisis"
chow_c(7,3)="Prob F"
chow_c(7,4)="Prob Chi-Square"


!i = 8
for %x AR1 AR2 AR3 AR4 BR1 BR2 BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE

	chow_c(!i,1)= %x
	chow_c(!i,2)= @right(chow_{%x}_c(1,1),7)
	chow_c(!i,3)= chow_{%x}_c(6,5)
	chow_c(!i,4)= chow_{%x}_c(7,5)
		
	!i = !i+1

next



table(41,8) chow_trend

setcell (chow_trend,1,1,"Chow breakpoint test","l")

chow_trend.settextcolor(1,1) blue
chow_trend.setfont(1,1) +b 14pt
chow_trend.setfont(2,1) -b 10pt

setcell (chow_trend,2,1,"Trend","l")
chow_trend(3,1)="log(real gdp) = alpha + beta*t + error"
chow_trend(4,1)="Null hypothesis: no breaks at specified breakpoints"
setline(chow,5)



chow_trend(6,2)="Beginning crisis"
chow_trend(7,3)="Prob F"
chow_trend(7,4)="Prob Chi-Square"


!i = 8
for %x AR1 AR2 AR3 AR4 BR1 BR2 BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE

	chow_trend(!i,1)= %x
	chow_trend(!i,2)= @right(chow_{%x}_trend(1,1),7)
	chow_trend(!i,3)= chow_{%x}_trend(6,5)
	chow_trend(!i,4)= chow_{%x}_trend(7,5)
		
	!i = !i+1

next


'III. Quandt-Andrews unkown breakpoint 
'----------------------------------------------------------


pageselect  quandt

table(41,14) quandt

setcell (quandt,1,1,"Quandt-Andrews unknown breakpoint test","l")

quandt.settextcolor(1,1) blue
quandt.setfont(1,1) +b 14pt
quandt.setfont(2,1) -b 10pt


quandt(2,1)=quandt_{%y}(2,1)
quandt(3,1)=quandt_{%y}(3,1)


setline(quandt,4)


quandt(5,3)="P-value break"
quandt(5,4)="P-value date"

quandt(6,2)="Break"
quandt(6,3)="Exp LR F-statistic"
quandt(6,4)="Maximum LR F_statistic"

quandt.setwidth(3:4) 15

!i = 7
for %y AR BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE


	quandt(!i,1)=%y
	quandt(!i,2)=@right(quandt_{%y}(10,1),8)
	quandt(!i,3)=quandt_{%y}(12,4)
	quandt(!i,4)=quandt_{%y}(10,4)
		
	!i = !i+1

next


table(41,14) quandt_c

setcell (quandt_c,1,1,"Quandt-Andrews unknown breakpoint test","l")

quandt_c.settextcolor(1,1) blue
quandt_c.setfont(1,1) +b 14pt
quandt_c.setfont(2,1) -b 10pt


quandt_c(2,1)=quandt_{%y}_c(2,1)
quandt_c(3,1)=quandt_{%y}_c(3,1)


setline(quandt_c,4)


quandt_c(5,3)="P-value break"
quandt_c(5,4)="P-value date"

quandt_c(6,2)="Break"
quandt_c(6,3)="Exp LR F-statistic"
quandt_c(6,4)="Maximum LR F_statistic"
quandt_c.setwidth(3:4) 15

!i = 7
for %y AR BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE


	quandt_c(!i,1)=%y
	quandt_c(!i,2)=@right(quandt_{%y}_c(10,1),8)
	quandt_c(!i,3)=quandt_{%y}_c(12,4)
	quandt_c(!i,4)=quandt_{%y}_c(10,4)
		
	!i = !i+1

next



table(41,14) quandt_trend

setcell (quandt_trend,1,1,"Quandt-Andrews unknown breakpoint test","l")

quandt_trend.settextcolor(1,1) blue
quandt_trend.setfont(1,1) +b 14pt
quandt_trend.setfont(2,1) -b 10pt


quandt_trend(2,1)=quandt_{%y}_trend(2,1)
quandt_trend(3,1)=quandt_{%y}_trend(3,1)


setline(quandt_trend,4)
quandt_trend.setwidth(3:4) 15

quandt_trend(5,3)="P-value break"
quandt_trend(5,4)="P-value date"

quandt_trend(6,2)="Break"
quandt_trend(6,3)="Exp LR F-statistic"
quandt_trend(6,4)="Maximum LR F_statistic"


!i = 7
for %y AR BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE


	quandt_trend(!i,1)=%y
	quandt_trend(!i,2)=@right(quandt_{%y}_trend(10,1),8)
	quandt_trend(!i,3)=quandt_{%y}_trend(12,4)
	quandt_trend(!i,4)=quandt_{%y}_trend(10,4)
		
	!i = !i+1

next


'IV. Size breaks model log
'----------------------------------------------------------

pageselect model_1dummy


table(41,14) model_log_size

setcell (model_log_size,1,1,"Regressions on dummies","l")

model_log_size.settextcolor(1,1) blue
model_log_size.setfont(1,1) +b 14pt
model_log_size.setfont(2,1) -b 10pt

setline(model_log_size,4)

setcell(model_log_size,2,1,"Both level & trend","l")

model_log_size(3,1)="log(real gdp) = alpha + a1D1 + beta*t + b1D1t + error"
model_log_size(5,1)=""

model_log_size(6,2)="a1"
model_log_size(6,3)="t1"
model_log_size(6,4)="t2"
model_log_size(6,5)="b1"
model_log_size(6,6)="t1"
model_log_size(6,7)="t2"

!i = 7
for %x 1_AR 2_AR 3_AR 4_AR 1_BR 2_BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE 


	model_log_size(!i,1)=%x
	model_log_size(!i,2)=eq_dum_{%x}.@coefs(2)
	model_log_size(!i,3)=eq_dum_{%x}.@coefs(2) -1.64*eq_dum_{%x}.@stderrs(2)
	model_log_size(!i,4)=eq_dum_{%x}.@coefs(2) +1.64*eq_dum_{%x}.@stderrs(2)
	model_log_size(!i,5)=eq_dum_{%x}.@coefs(4)
	model_log_size(!i,6)=eq_dum_{%x}.@coefs(4) -1.64*eq_dum_{%x}.@stderrs(4)
	model_log_size(!i,7)=eq_dum_{%x}.@coefs(4) +1.64*eq_dum_{%x}.@stderrs(4)	
	
	!i = !i+1

next


table(41,14) model_log_size_c

setcell (model_log_size_c,1,1,"Regressions on dummies","l")

model_log_size_c.settextcolor(1,1) blue
model_log_size_c.setfont(1,1) +b 14pt
model_log_size_c.setfont(2,1) -b 10pt

setline(model_log_size_c,4)

setcell (model_log_size_c,2,1,"Only level","l")

model_log_size_c(3,1)="log(real gdp) = alpha + a1D1 +beta*t + error"
model_log_size_c(5,1)=""

model_log_size_c(6,2)="a1"
model_log_size_c(6,3)="t1"
model_log_size_c(6,4)="t2"


!i = 7
for %x 1_AR 2_AR 3_AR 4_AR 1_BR 2_BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE 


	model_log_size_c(!i,1)=%x
	model_log_size_c(!i,2)=eq_dum_{%x}_c.@coefs(2)
	model_log_size_c(!i,3)=eq_dum_{%x}_c.@coefs(2) -1.64*eq_dum_{%x}_c.@stderrs(2)
	model_log_size_c(!i,4)=eq_dum_{%x}_c.@coefs(2) +1.64*eq_dum_{%x}_c.@stderrs(2)
	
	!i = !i+1

next



table(41,14) model_log_size_trend

setcell (model_log_size_trend,1,1,"Regressions on dummies","l")

model_log_size_trend.settextcolor(1,1) blue
model_log_size_trend.setfont(1,1) +b 14pt
model_log_size_trend.setfont(2,1) -b 10pt

setline(model_log_size_trend,4)

setcell (model_log_size_trend,2,1,"Only trend","l")

model_log_size_trend(3,1)="alpha+beta*t + b1D1t + error"
model_log_size_trend(5,1)=""

model_log_size_trend(6,2)="b1"
model_log_size_trend(6,3)="t1"
model_log_size_trend(6,4)="t2"


!i = 7
for %x 1_AR 2_AR 3_AR 4_AR 1_BR 2_BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE 


	model_log_size_trend(!i,1)=%x
	model_log_size_trend(!i,2)=eq_dum_{%x}_trend.@coefs(3)
	model_log_size_trend(!i,3)=eq_dum_{%x}_trend.@coefs(3) -1.64*eq_dum_{%x}_trend.@stderrs(3)
	model_log_size_trend(!i,4)=eq_dum_{%x}_trend.@coefs(3) +1.64*eq_dum_{%x}_trend.@stderrs(3)
	
	!i = !i+1

next



pageselect model_2dummies

table(41,14) model_log_2dum

setcell (model_log_2dum,1,1,"Regressions on dummies","l")

model_log_2dum.settextcolor(1,1) blue
model_log_2dum.setfont(1,1) +b 14pt
model_log_2dum.setfont(2,1) -b 10pt

setline(model_log_2dum,4)

setcell (model_log_2dum,2,1,"Both level & trend","l")

model_log_2dum(3,1)="log(real gdp) = alpha + a1D1 + a2D2 +beta*t + b1D1t + b2D2t + error"
model_log_2dum(5,1)=""

model_log_2dum(6,2)="a1"
model_log_2dum(6,3)="t1"
model_log_2dum(6,4)="t2"
model_log_2dum(6,5)="a2"
model_log_2dum(6,6)="t1"
model_log_2dum(6,7)="t2"
model_log_2dum(6,8)="b1"
model_log_2dum(6,9)="t1"
model_log_2dum(6,10)="t2"
model_log_2dum(6,11)="b2"
model_log_2dum(6,12)="t1"
model_log_2dum(6,13)="t2"


!i = 7
for %x 1_AR 2_AR 3_AR 4_AR 1_BR 2_BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE 


	model_log_2dum(!i,1)=%x
	model_log_2dum(!i,2)=eq_2dum_{%x}_all.@coefs(2)
	model_log_2dum(!i,3)=eq_2dum_{%x}_all.@coefs(2) -1.64*eq_2dum_{%x}_all.@stderrs(2)
	model_log_2dum(!i,4)=eq_2dum_{%x}_all.@coefs(2) +1.64*eq_2dum_{%x}_all.@stderrs(2)
	model_log_2dum(!i,5)=eq_2dum_{%x}_all.@coefs(3)
	model_log_2dum(!i,6)=eq_2dum_{%x}_all.@coefs(3) -1.64*eq_2dum_{%x}_all.@stderrs(3)
	model_log_2dum(!i,7)=eq_2dum_{%x}_all.@coefs(3) +1.64*eq_2dum_{%x}_all.@stderrs(3)	
	model_log_2dum(!i,8)=eq_2dum_{%x}_all.@coefs(5)
	model_log_2dum(!i,9)=eq_2dum_{%x}_all.@coefs(5) -1.64*eq_2dum_{%x}_all.@stderrs(5)
	model_log_2dum(!i,10)=eq_2dum_{%x}_all.@coefs(5) +1.64*eq_2dum_{%x}_all.@stderrs(5)
	model_log_2dum(!i,11)=eq_2dum_{%x}_all.@coefs(6)
	model_log_2dum(!i,12)=eq_2dum_{%x}_all.@coefs(6) -1.64*eq_2dum_{%x}_all.@stderrs(6)
	model_log_2dum(!i,13)=eq_2dum_{%x}_all.@coefs(6) +1.64*eq_2dum_{%x}_all.@stderrs(6)	
	!i = !i+1

next


table(41,14) model_log_2dum_c

setcell (model_log_2dum_c,1,1,"Regressions on dummies","l")

model_log_2dum_c.settextcolor(1,1) blue
model_log_2dum_c.setfont(1,1) +b 14pt
model_log_2dum_c.setfont(2,1) -b 10pt

setline(model_log_2dum_c,4)

setcell (model_log_2dum_c,2,1,"Only level","l")

model_log_2dum_c(3,1)="log(real gdp) = alpha + a1D1 + a2D2 +beta*t + error"
model_log_2dum_c(5,1)=""

model_log_2dum_c(6,2)="a1"
model_log_2dum_c(6,3)="t1"
model_log_2dum_c(6,4)="t2"
model_log_2dum_c(6,5)="a2"
model_log_2dum_c(6,6)="t1"
model_log_2dum_c(6,7)="t2"

!i = 7
for %x 1_AR 2_AR 3_AR 4_AR 1_BR 2_BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE 


	model_log_2dum_c(!i,1)=%x
	model_log_2dum_c(!i,2)=eq_2dum_{%x}_c.@coefs(2)
	model_log_2dum_c(!i,3)=eq_2dum_{%x}_c.@coefs(2) -1.64*eq_2dum_{%x}_c.@stderrs(2)
	model_log_2dum_c(!i,4)=eq_2dum_{%x}_c.@coefs(2) +1.64*eq_2dum_{%x}_c.@stderrs(2)
	model_log_2dum_c(!i,5)=eq_2dum_{%x}_c.@coefs(3)
	model_log_2dum_c(!i,6)=eq_2dum_{%x}_c.@coefs(3) -1.64*eq_2dum_{%x}_c.@stderrs(3)
	model_log_2dum_c(!i,7)=eq_2dum_{%x}_c.@coefs(3) +1.64*eq_2dum_{%x}_c.@stderrs(3)	
	
	!i = !i+1

next




table(41,14) model_log_2dum_trend

setcell (model_log_2dum_trend,1,1,"Regressions on dummies","l")

model_log_2dum_trend.settextcolor(1,1) blue
model_log_2dum_trend.setfont(1,1) +b 14pt
model_log_2dum_trend.setfont(2,1) -b 10pt

setline(model_log_2dum_trend,4)

setcell (model_log_2dum_trend,2,1,"Only trend","l")

model_log_2dum_trend(3,1)="alpha+beta*t + b1D1t + b2D2t + error"
model_log_2dum_trend(5,1)=""

model_log_2dum_trend(6,2)="b1"
model_log_2dum_trend(6,3)="t1"
model_log_2dum_trend(6,4)="t2"
model_log_2dum_trend(6,5)="b2"
model_log_2dum_trend(6,6)="t1"
model_log_2dum_trend(6,7)="t2"

!i = 7
for %x 1_AR 2_AR 3_AR 4_AR 1_BR 2_BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE 


	model_log_2dum_trend(!i,1)=%x
	model_log_2dum_trend(!i,2)=eq_2dum_{%x}_trend.@coefs(3)
	model_log_2dum_trend(!i,3)=eq_2dum_{%x}_trend.@coefs(3) -1.64*eq_2dum_{%x}_trend.@stderrs(3)
	model_log_2dum_trend(!i,4)=eq_2dum_{%x}_trend.@coefs(3) +1.64*eq_2dum_{%x}_trend.@stderrs(3)
	model_log_2dum_trend(!i,5)=eq_2dum_{%x}_trend.@coefs(4)
	model_log_2dum_trend(!i,6)=eq_2dum_{%x}_trend.@coefs(4) -1.64*eq_2dum_{%x}_trend.@stderrs(4)
	model_log_2dum_trend(!i,7)=eq_2dum_{%x}_trend.@coefs(4) +1.64*eq_2dum_{%x}_trend.@stderrs(4)	
	
	!i = !i+1

next





pageselect model_1dummy

table(41,14) variance

setcell (variance,1,1,"Regressions on dummies","l")

variance.settextcolor(1,1) blue
variance.setfont(1,1) +b 14pt
variance.setfont(2,1) -b 10pt

setline(variance,4)

setcell(variance,2,1,"Both level & trend","l")

variance(3,1)="log(real gdp) = alpha + a1D1 + beta*t + b1D1t + error"
variance(5,1)=""

variance(6,2)="a1"
variance(6,3)="se"
variance(6,4)="b1"
variance(6,5)="se"
variance(6,6)="c"
variance(6,7)="variance"
!i = 7
for %x 1_AR 2_AR 3_AR 4_AR 1_BR 2_BR BG CL CO CI HR CZ DM EC EE FI GH ID JM JP KR LV LT MY MX NO PH RU SE TH TR UA UY VE 


	variance(!i,1)=%x
	variance(!i,2)=eq_dum_{%x}.@coefs(2)
	variance(!i,3)=eq_dum_{%x}.@stderrs(2)
	variance(!i,4)=eq_dum_{%x}.@coefs(4)
	variance(!i,5)=eq_dum_{%x}.@stderrs(4)
	variance(!i,6)=nbobs_{%x}
	variance(!i,7)=eq_dum_{%x}.@stderrs(2)*eq_dum_{%x}.@stderrs(2) + nbobs_{%x}*nbobs_{%x}*eq_dum_{%x}.@stderrs(4)*eq_dum_{%x}.@stderrs(4)

	!i = !i+1

next

save exercise_end_official

